.386
.MODEL FLAT
IDEAL

;

SEGMENT _TEXT PARA

PROC StampToTime ; EAX<-Stamp, EDX<-pBuff
	push	0
	push	eax
	fild	qword [esp]
	fadd  qword [@@add]
	add	esp, 8
	fmul	dword [@@mul]
	fistp	qword [edx]
	ret
ALIGN 8
@@add:
	DQ 11644473600.0
@@mul:
	DD 10000000.0
ENDP

ENDS

;

SEGMENT _TEXT PARA

PROC DecToInt ; EAX<-pDecStr
	movzx	ecx, byte [eax]
	xor	edx, edx
	push	ecx
	cmp	cl, '-'
	ja		@@1
	inc	eax
	jmp	@@loop
ALIGN 16
@@loop:
	movzx	ecx, byte [eax]
@@1:
	test	ecx, ecx
	jz		@@fin
	lea	ecx, [ecx+edx*2-48]
	inc	eax
	lea	edx, [ecx+edx*8]
	jmp	@@loop
@@fin:
	mov	eax, edx
	pop	edx
	cmp	dl, '-'
	jne	@@end
	neg	eax
@@end:
	ret
ENDP

ENDS

;

SEGMENT _TEXT PARA

PROC MemSet4x ; EAX<-pDest, EDX<-Value, ECX<-Count
	push	edi
	mov	edi, eax
	mov	eax, edx
	rep stosd
	pop	edi
	ret
ENDP

ENDS

;

SEGMENT _TEXT PARA

PROC CopyText ; EAX<-pDst, EDX<-pSrc, ECX<-Max, [ESP+4]<-Term
	push	ebx
	push	ecx
	test	ecx, ecx
	jz		@@fin
	mov	bh, [esp+12]
	jmp	@@loop
ALIGN 16
@@loop:
	mov	bl, [edx]
	inc	edx
	cmp	bl, bh
	je		@@fin
	mov	[eax], bl
	inc	eax
	dec	ecx
	jnz	@@loop
@@fin:
	mov	byte [eax], 0
	pop	eax
	pop	ebx
	sub	eax, ecx
	ret	4
ENDP

ENDS

;

SEGMENT _TEXT PARA

PROC GetCmdArgsW ; EAX<-pArgPtrs, EDX<-BufSize, ECX<-pCmdStr
	push	edi
	push	esi

	mov	esi, ecx
	mov	edi, eax
	shr	edx, 2
	mov	ecx, edx
	push	edx
	xor	edx, edx
	jmp	@@loop

ALIGN 16
@@loop:
	movzx	eax, word [esi]
	add	esi, 2
	test	eax, eax
	jz		@@fin
	cmp	eax, ' '
	jbe	@@loop
	dec	ecx
	jz		@@fin
	cmp	eax, '"'
	je		@@quote
	lea	eax, [esi-2]
	stosd
	jmp	@@loop_p
ALIGN 16
@@loop_p:
	movzx	eax, word [esi]
	add	esi, 2
	cmp	eax, ' '
	ja		@@loop_p
	test	eax, eax
	jz		@@fin
	mov	[esi-2], dx
	jmp	@@loop
@@quote:
	mov	[edi], esi
	add	edi, 4
	jmp	@@loop_q
ALIGN 16
@@loop_q:
	movzx	eax, word [esi]
	add	esi, 2
	cmp	eax, '"'
	jne	@@loop_q
	test	eax, eax
	jz		@@fin
	mov	[esi-2], dx
	jmp	@@loop

@@fin:
	mov	[edi], edx
	pop	eax
	sub	eax, ecx

	pop	esi
	pop	edi
	ret
ENDP ; EAX = count

ENDS

;

PUBLIC StampToTime, DecToInt
PUBLIC MemSet4x, CopyText
PUBLIC GetCmdArgsW

END
